/*
  This tower of magi is 10 units high and 1.5 wide.
*/

// Here is all stuff that is not used in main file
#ifndef (TheCity)
  light_source { <10,15,-15> color rgb 1 }
  camera { location <3,10.5,-4> look_at <.7,8,.75> angle 40 }
#end

#local Wall_colour = 
texture {
  pigment { 
    granite
    turbulence 0.5
    color_map {
      [0.000 color rgb <.3,.4,.4>]
      [0.559 color rgb .6]
      [1.000 color rgb <0.25,.4,.4>]
    }
    scale .3
  } 
  normal {
    gradient y .15
    turbulence 0.7
    scale .075
  }
}

#local Roof_colour = texture {
  pigment { 
    granite
    turbulence 0.5
    color_map {
      [0.000 color rgb <0.3,0.1,0.1>]
      [0.559 color rgb <0.5,0.25,0.25>]
      [1.000 color rgb <0.25,0.1,0.1>]
    }
    scale .1
  }

}

#local torni_width = 2;
#local torni_height = 9;

#local tiili_nro_x = 13;     // How many brics is in one row
#local tiili_nro_y = 90;    // How many bricklayers there is

#local tiili_x = torni_width/tiili_nro_x;       // Legth of tower wall divedid by number of bricks in one row
#local tiili_y = torni_height/tiili_nro_y;      // Heigth of tower divedid by number of bricklayers
#local tiili_z = tiili_x*4/3;                   // Depth of brick, determines how wall is tiled and how thick it is, works unbelievably well

#local reunus = 0.01;

#local tiili_1 = difference {
  box { <0,0,0> <tiili_x,tiili_y,tiili_z> }
  plane { y+z 0 translate <0,reunus,0> }
  plane { -y+z 0 translate <0,tiili_y-2*reunus,0> }
  plane { x+z 0 translate <reunus,0,0> }
  plane { -x+z 0 translate <tiili_x-reunus,0,0> }
}

#local tiili_2 = difference {
  box { <0,0,0> <tiili_x,tiili_y,tiili_z> }
  plane { y+z 0 translate <0,reunus,0> }
  plane { -y+z 0 translate <0,tiili_y-2*reunus,0> }
  plane { x+z 0 translate <reunus,0,0> }
  plane { -x+z 0 translate <tiili_x-reunus,0,0> }
  plane { -x+z 0 translate <tiili_x-reunus,0,0> }
}

#local tiili_3 = difference {
  box { <0,0,0> <tiili_x,tiili_y,tiili_z> }
  plane { y+z 0 translate <0,reunus,0> }
  plane { -y+z 0 translate <0,tiili_y-2*reunus,0> }
  plane { x+z 0 translate <reunus,0,0> }
  plane { -x+z 0 translate <tiili_x-reunus,0,0> }
  plane { x-z 0 translate <reunus,0,tiili_z> }
  plane { y+x 0 translate <0,reunus,tiili_z> }
  plane { -y+x 0 translate <0,tiili_y-reunus,tiili_z> }
}

#local tiili_4 = 
  box { <0,0,0> <tiili_z-tiili_x,tiili_y,tiili_z> }


#local tiili_kerros_2 = union {

  #local cx = 0;
  #while (cx < tiili_nro_x-1)
    object { tiili_1 translate <cx*tiili_x+tiili_z,0,0> texture { Wall_colour rotate y*60*cx} }
    #local cx = cx + 1;
  #end
  object { tiili_2 translate <(tiili_nro_x-1)*tiili_x+tiili_z,0,0> texture { Wall_colour rotate y*45*cx} }  

  object { tiili_2 rotate y*90 translate <0,0,tiili_x> texture { Wall_colour rotate y*20*cx} }
  #local cx = 1;
  #while (cx < tiili_nro_x)
    object { tiili_1 rotate y*90 translate <0,0,tiili_x+cx*tiili_x> texture { Wall_colour rotate y*40*cx} }
    #local cx = cx + 1;
  #end
  
  object { tiili_2 translate <0,0,tiili_x*tiili_nro_x> texture { Wall_colour rotate y*30*cx} }
  #local cx = 1;
  #while (cx < tiili_nro_x)
    object { tiili_1 translate <cx*tiili_x,0,tiili_x*tiili_nro_x> texture { Wall_colour rotate y*20*cx} }
    #local cx = cx + 1;
  #end

  #local cx = 0;
  #while (cx < tiili_nro_x -1)
    object { tiili_1 rotate y*-90 translate <tiili_nro_x*tiili_x+tiili_z,0,cx*tiili_x+tiili_z> texture { Wall_colour rotate y*50*cx} }
    #local cx = cx + 1;
  #end
  object { tiili_2 rotate y*-90 translate <tiili_nro_x*tiili_x+tiili_z,0,(tiili_nro_x-1)*tiili_x+tiili_z> texture { Wall_colour rotate y*20*cx} }

}

#local tiili_kerros_3 = union {

  object { tiili_3 translate <0,0,0> }
  #local cx = 1;
  #while (cx < tiili_nro_x)
    object { tiili_1 translate <cx*tiili_x,0,0> texture { Wall_colour rotate y*30*cx} }
    #local cx = cx + 1;
  #end

  #local cx = 0;
  #while (cx < tiili_nro_x-1)
    object { tiili_1 rotate y*90 translate <0,0,tiili_x+cx*tiili_x+tiili_z> texture { Wall_colour rotate y*32*cx} }
    #local cx = cx + 1;
  #end
  object { tiili_3 rotate y*90 translate <0,0,tiili_x+(tiili_nro_x-1)*tiili_x+tiili_z> texture { Wall_colour rotate y*21*cx} }

  #local cx = 0;
  #while (cx < tiili_nro_x-1)
    object { tiili_1 translate <cx*tiili_x+tiili_z,0,tiili_x*tiili_nro_x> texture { Wall_colour rotate y*34*cx} }
    #local cx = cx + 1;
  #end
  object { tiili_3 translate <(tiili_nro_x-1)*tiili_x+tiili_z,0,tiili_x*tiili_nro_x> texture { Wall_colour rotate y*23*cx} }

  object { tiili_3 rotate y*-90 translate <tiili_nro_x*tiili_x+tiili_z,0,0> texture { Wall_colour rotate y*30*cx} }
  #local cx = 1;
  #while (cx < tiili_nro_x)
    object { tiili_1 rotate y*-90 translate <tiili_nro_x*tiili_x+tiili_z,0,cx*tiili_x> texture { Wall_colour rotate y*43*cx} }
    #local cx = cx + 1;
  #end

}









                      
// Determines something
// These may not work with all tower values
#local seina = 2;   
#local akkuna = 4;

#local tiili_kerros_4 = union {

  #local cx = 0;
  #while (cx < 1)
    object { tiili_1 rotate y*-1*cos(-cx) translate <cx*tiili_x+tiili_z,0,0> texture { Wall_colour rotate y*32*cx} }
    #local cx = cx + 1;
  #end
  #while (cx < akkuna)
    #local cx = cx + 1;
  #end
  object { tiili_4 rotate y*-1*cos(-cx) translate <(cx+2)*tiili_x,0,0> texture { Wall_colour rotate y*35*cx} }
  #local cx = cx + 1;
  #while (cx < tiili_nro_x-seina-akkuna)
    object { tiili_1 rotate y*-1*cos(-cx) translate <cx*tiili_x+tiili_z,0,0> texture { Wall_colour rotate y*30*cx} }
    #local cx = cx + 1;
  #end
  #while (cx < tiili_nro_x-seina-1)
    #local cx = cx + 1;
  #end
  object { tiili_4 rotate y*-1*cos(-cx) translate <(cx+2)*tiili_x,0,0> texture { Wall_colour rotate y*33*cx} }
  #local cx = cx + 1;
  #while (cx < tiili_nro_x-1)
    object { tiili_1 rotate y*-1*cos(-cx) translate <cx*tiili_x+tiili_z,0,0> texture { Wall_colour rotate y*33*cx} }
    #local cx = cx + 1;
  #end
  object { tiili_2 translate <(tiili_nro_x-1)*tiili_x+tiili_z,0,0> }  

  object { tiili_2 rotate y*90 translate <0,0,tiili_x> texture { Wall_colour rotate y*30*cx} }
  #local cx = 1;
  #while (cx < tiili_nro_x)
    object { tiili_1 rotate y*90 rotate y*cos(cx) translate <0,0,tiili_x+cx*tiili_x> texture { Wall_colour rotate y*42*cx} }
    #local cx = cx + 1;
  #end
  
  object { tiili_2 translate <0,0,tiili_x*tiili_nro_x> texture { Wall_colour rotate y*30*cx} }
  #local cx = 1;
  #while (cx < tiili_nro_x)
    object { tiili_1 rotate y*cos(-cx) translate <cx*tiili_x,0,tiili_x*tiili_nro_x> texture { Wall_colour rotate y*38*cx} }
    #local cx = cx + 1;
  #end

  #local cx = 0;
  #while (cx < tiili_nro_x -1)
    object { tiili_1 rotate y*-90 rotate y*cos(cx) translate <tiili_nro_x*tiili_x+tiili_z,0,cx*tiili_x+tiili_z> texture { Wall_colour rotate y*30*cx} }
    #local cx = cx + 1;
  #end
  object { tiili_2 rotate y*-90 translate <tiili_nro_x*tiili_x+tiili_z,0,(tiili_nro_x-1)*tiili_x+tiili_z> texture { Wall_colour rotate y*42*cx} }

}

#local tiili_kerros_5 = union {

  object { tiili_3 translate <0,0,0> texture { Wall_colour rotate y*30*cx} }
  #local cx = 1;
  #while (cx < seina)
    object { tiili_1 rotate y*2*sin(cx) translate <cx*tiili_x,0,0> texture { Wall_colour rotate y*30*cx} }
    #local cx = cx + 1;
  #end
  object { tiili_4 rotate y*2*sin(cx) translate <cx*tiili_x,0,0> texture { Wall_colour rotate y*30*cx} }
  #while (cx < 2 + akkuna)
    #local cx = cx + 1;
  #end
  #while (cx < tiili_nro_x-seina+1-akkuna)
    object { tiili_1 rotate y*2*sin(cx) translate <cx*tiili_x,0,0> texture { Wall_colour rotate y*40*cx} }
    #local cx = cx + 1;
  #end
  object { tiili_4 rotate y*2*sin(cx) translate <cx*tiili_x,0,0> texture { Wall_colour rotate y*20*cx} }
  #while (cx < tiili_nro_x-seina+1)
    #local cx = cx + 1;
  #end
  #while (cx < tiili_nro_x)
    object { tiili_1 rotate y*2*sin(cx) translate <cx*tiili_x,0,0> texture { Wall_colour rotate y*30*cx} }
    #local cx = cx + 1;
  #end



  #local cx = 0;
  #while (cx < tiili_nro_x-1)
    object { tiili_1 rotate y*90 rotate y*-1*sin(-cx) translate <0,0,tiili_x+cx*tiili_x+tiili_z> texture { Wall_colour rotate y*20*cx} }
    #local cx = cx + 1;
  #end
  object { tiili_3 rotate y*90 translate <0,0,tiili_x+(tiili_nro_x-1)*tiili_x+tiili_z> texture { Wall_colour rotate y*40*cx} }

  #local cx = 0;
  #while (cx < tiili_nro_x-1)
    object { tiili_1 rotate y*-1*sin(cx) translate <cx*tiili_x+tiili_z,0,tiili_x*tiili_nro_x> texture { Wall_colour rotate y*30*cx} }
    #local cx = cx + 1;
  #end
  object { tiili_3 translate <(tiili_nro_x-1)*tiili_x+tiili_z,0,tiili_x*tiili_nro_x> texture { Wall_colour rotate y*30*cx} }

  object { tiili_3 rotate y*-90 translate <tiili_nro_x*tiili_x+tiili_z,0,0> texture { Wall_colour rotate y*30*cx} }
  #local cx = 1;
  #while (cx < tiili_nro_x)
    object { tiili_1 rotate y*-90 rotate y*sin(-cx) translate <tiili_nro_x*tiili_x+tiili_z,0,cx*tiili_x> texture { Wall_colour rotate y*35*cx} }
    #local cx = cx + 1;
  #end

}


#local s = 9;
#local e = 7;

#local cy = 0;
#while (cy < tiili_nro_y - s )
  object { tiili_kerros_2   rotate <0,.2-.2*mod(cy ,4),0> texture { Wall_colour rotate -y*30*cy} translate <-.5,cy*tiili_y,0> }
  object { tiili_kerros_3   texture { Wall_colour rotate y*30*cy} translate <-.5,(cy+1)*tiili_y,0> }
  #local cy = cy + 2;
#end
#while (cy < tiili_nro_y -s +e )
  object { tiili_kerros_4   rotate <0,.2-.2*mod(cy ,4),0> texture { Wall_colour rotate -y*30*cy} translate <-.5,cy*tiili_y,0> }
  object { tiili_kerros_5   texture { Wall_colour rotate y*30*cy} translate <-.5,(cy+1)*tiili_y,0> }
  #local cy = cy + 2;
#end
#while (cy < tiili_nro_y)
  object { tiili_kerros_2   rotate <0,.2-.2*mod(cy ,4),0> texture { Wall_colour rotate -y*30*cy} translate <-.5,cy*tiili_y,0> }
  object { tiili_kerros_3   translate <-.5,(cy+1)*tiili_y,0> }
  #local cy = cy + 2;
#end

/*
  Box-Coordinates for two windows are
  <tiili_z+(seina-1)*tiili_x-.5,(tiili_nro_y-s+1)*tiili_y,0> <(seina+akkuna)*tiili_x-.5,(tiili_nro_y-s+e)*tiili_y,tiili_z>
  <(tiili_nro_x-1)*tiili_x-.5,(tiili_nro_y-s+1)*tiili_y,0> <(tiili_nro_x-2-akkuna)*tiili_x+tiili_z-.5,(tiili_nro_y-s+e)*tiili_y,tiili_z>
*/

// lattia
box { <tiili_z-.5,(tiili_nro_y-s+1)*tiili_y,tiili_z> <torni_width-.5,(tiili_nro_y-s)*tiili_y,torni_width> texture { Wall_colour } texture { pigment { color rgbt t*.5 } } }

#local holvireunus = 3*reunus;

#local holvi = .025;
#local wikkuna = 
difference {
  box { // Holvin kiveys
    <tiili_z+(seina-1)*tiili_x-.5,(tiili_nro_y-s+1)*tiili_y,0>
    <(seina+akkuna)*tiili_x-.5,(tiili_nro_y-s+e)*tiili_y,tiili_z> 
  }
  box { // ulkoreunan pyristys
    <0,0,-1> <2,1,0>
    rotate x*-45
    translate <tiili_z+(seina-1)*tiili_x-.5,(tiili_nro_y-s+e)*tiili_y,reunus> 
  }
  box { // ulkoreunan pyristys
    <0,0,0> <-1,1,-1>
    rotate y*-45
    translate <tiili_z+(seina-1)*tiili_x-.5,(tiili_nro_y-s+1)*tiili_y,0>
    translate z*reunus
  }
  box { // ulkoreunan pyristys
    <0,0,0> <1,1,-1>
    rotate y*45
    translate <(seina+akkuna)*tiili_x-.5,(tiili_nro_y-s+1)*tiili_y,0>
    translate z*reunus
  }
  cylinder { // Spherical window area 
    <tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5, (tiili_nro_y-s+e)*tiili_y-((tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5-(tiili_z+(seina-1)*tiili_x-.5))*(1+holvi)), -1> 
    <tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5, (tiili_nro_y-s+e)*tiili_y-((tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5-(tiili_z+(seina-1)*tiili_x-.5))*(1+holvi)), 2*tiili_z> 
    (tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5-(tiili_z+(seina-1)*tiili_x-.5))-akkuna*holvi
  }
  box { // Window-area 
    <(tiili_z+(seina-1)*tiili_x-.5)+akkuna*holvi, (tiili_nro_y-s+1)*tiili_y-1,-1> 
    <((seina+akkuna)*tiili_x-.5)-akkuna*holvi, (tiili_nro_y-s+e)*tiili_y-((tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5-(tiili_z+(seina-1)*tiili_x-.5))*(1+holvi)),tiili_z*2> 
  }
  box { // Reunan pyristyt irtileikattuun laatikkoon
    <0,0,0> <1,-1,-1>
    rotate y*45
    translate <(tiili_z+(seina-1)*tiili_x-.5)+akkuna*holvi,(tiili_nro_y-s+e)*tiili_y-((tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5-(tiili_z+(seina-1)*tiili_x-.5))*(1+holvi)),holvireunus>
  }
  box { // Reunan pyristyt irtileikattuun laatikkoon
    <0,0,0> <-1,-1,-1>
    rotate y*-45
    translate <((seina+akkuna)*tiili_x-.5)-akkuna*holvi,(tiili_nro_y-s+e)*tiili_y-((tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5-(tiili_z+(seina-1)*tiili_x-.5))*(1+holvi)),holvireunus>
  }
  cone { // Reunuksen pyristys
    <tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5, (tiili_nro_y-s+e)*tiili_y-((tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5-(tiili_z+(seina-1)*tiili_x-.5))*(1+holvi)),0>
    (tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5-(tiili_z+(seina-1)*tiili_x-.5))-akkuna*holvi
    <tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5, (tiili_nro_y-s+e)*tiili_y-((tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5-(tiili_z+(seina-1)*tiili_x-.5))*(1+holvi)),-2*tiili_z> 
    (tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5-(tiili_z+(seina-1)*tiili_x-.5))-akkuna*holvi+2*tiili_z
    translate <0,0,holvireunus>
  }

  // holvikaaren saumat
  #local halkea = 7;
  #local laske = 0;
  #while (laske < halkea +1 )
    box {<0,0,0> <-1,1,-1> rotate <-45,0,-180/halkea*laske>
      translate <tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5,(tiili_nro_y-s+e)*tiili_y-((tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5-(tiili_z+(seina-1)*tiili_x-.5))*(1+holvi)),reunus> }
    #local laske = laske +1;
  #end

  // holvikaaren ala-osan saumat
  #local halkea2 = 2;
  #local laske = 0;
  #while (laske < halkea2 )
    box { <1,0,0> <-1,1,-1> rotate <-45,0,0>
      translate <tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5,(tiili_nro_y-s+1)*tiili_y+(laske+1)/(halkea2+1)*  (  ((tiili_nro_y-s+e)*tiili_y-((tiili_z+(seina-1)*tiili_x+((akkuna+1)*tiili_x-tiili_z)/2-.5-(tiili_z+(seina-1)*tiili_x-.5))*(1+holvi)))-(tiili_nro_y-s+1)*tiili_y  )  ,reunus> 
    }
    #local laske = laske +1;
  #end

  texture { Wall_colour }
}

object {wikkuna }
object {wikkuna translate x*(((tiili_nro_x-1)*tiili_x-.5)-((seina+akkuna)*tiili_x-.5)) }

/////////////////////////////////////////////////////////////////////////////////////////////////

#local roof_width = 2*torni_width;   // Maximum width of roof
#local roof_height = 2*torni_width;   // How long roof is at slope-side. Determines actual height of roof.

#local roof_nro_x = 30;     // How many brics is in one row
#local roof_nro_z = 15;     // How many bricklayers there is

#local roof_x = roof_width/roof_nro_x;      // Legth of tower wall divedid by number of bricks in one row
#local roof_y = roof_x/7;                   // This determines thickness of the roof compared to width of it
#local roof_z = roof_height/roof_nro_z;     // Heigth of tower divedid by number of bricklayers

#local roof_extra_angle = -55;

#local kattotiili = union {
  box { <0,0,roof_x/2> <roof_x,roof_y,roof_z> scale .96 }
  cylinder { <roof_x/2,0,roof_x/2> <roof_x/2,roof_y,roof_x/2> roof_x/1.99 }
  }


#local tiilirivi = union {
#local i = 0;
#while (i<roof_nro_x)
  object { kattotiili rotate <3*sin(i),2*cos(i),sin(-i)> translate <roof_x*i,0,0> }
  #local i=i+1;
#end
}

#local roof = 
union {
  #local i = 0;
  #while (i<roof_nro_z)
    difference { 
      object { tiilirivi translate <roof_x*mod(i,2)/2-roof_width/2+(torni_width+tiili_z)/2,roof_y*i,roof_z/2*i-.25*roof_z> rotate <roof_extra_angle,0,0> texture { Roof_colour rotate y*30*i } }
      plane { x-z 0 texture { Roof_colour rotate y*30*i } }
      plane { -x-z 0 translate <torni_width+tiili_z,0,0> texture { Roof_colour rotate y*30*i } }
    }
    #local i=i+1;
  #end
}

object { roof translate <-.5,torni_height,0> }
object { roof rotate <0,-180,0> translate <-.5+torni_width+tiili_z,torni_height,torni_width+tiili_z> }
object { roof rotate <0,-90,0> translate <-.5+torni_width+tiili_z,torni_height,0> }
object { roof rotate <0,90,0> translate <-.5,torni_height,torni_width+tiili_z> }

